/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.panels;

import ancestris.modules.editors.aries.AriesTopComponent;
import ancestris.modules.editors.aries.editors.FamilyEditor;
import ancestris.modules.editors.aries.editors.IndividualEditor;
import ancestris.modules.editors.aries.models.FamilyReferencesTreeTableModel;
import ancestris.modules.editors.aries.panels.FamiliesTablePanel;
import ancestris.util.swing.DialogManager;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyXRef;
import genj.gedcom.UnitOfWork;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.openide.DialogDescriptor;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public class FamiliesReferenceTreeTablePanel
extends JPanel {
    public static int LIST_FAM = 0;
    public static int EDIT_FAMC = FamilyReferencesTreeTableModel.FAMILY_CHILD;
    public static int EDIT_FAMS = FamilyReferencesTreeTableModel.FAMILY_SPOUSE;
    private static final Logger LOGGER = Logger.getLogger(FamiliesReferenceTreeTablePanel.class.getName(), null);
    private final ChangeListner changeListner = new ChangeListner();
    private final ChangeSupport changeSupport = new ChangeSupport(FamiliesReferenceTreeTablePanel.class);
    private int mFamilyEditingType = EDIT_FAMC;
    private Registry mRegistry = Registry.get(FamiliesReferenceTreeTablePanel.class);
    private Property mRoot;
    private Fam mCreateFamily = null;
    private String mTableId = FamiliesReferenceTreeTablePanel.class.getName();
    PropertyXRef mAddChild = null;
    private JButton addFamilyButton;
    private JButton deleteFamilyButton;
    private JButton editButton;
    private JScrollPane familiesScrollPane;
    private JXTreeTable familiesTreeTable;
    private JToolBar familyNamesToolBar;
    private JButton linkToFamilyButton;

    public FamiliesReferenceTreeTablePanel() {
        this(EDIT_FAMC);
    }

    public FamiliesReferenceTreeTablePanel(int familyEditingType) {
        this.mFamilyEditingType = familyEditingType;
        this.initComponents();
        for (int index = 0; index < this.familiesTreeTable.getColumnModel().getColumnCount(); ++index) {
            int columnSize = this.mRegistry.get(this.mTableId + ".column" + index + ".size", 100);
            this.familiesTreeTable.getColumnModel().getColumn(index).setPreferredWidth(columnSize);
            LOGGER.log(Level.FINE, "FamiliesReferenceTreeTablePanel: table id {0} column index {1} size {2}", new Object[]{this.mTableId, index, columnSize});
        }
        HighlightPredicate MyHighlightPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                int rowIndex = adapter.row;
                TreePath path = FamiliesReferenceTreeTablePanel.this.familiesTreeTable.getPathForRow(rowIndex);
                Object lastPathComponent = path.getLastPathComponent();
                if (lastPathComponent instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.getUserObject() instanceof PropertyXRef) {
                        Entity entity = ((PropertyXRef)node.getUserObject()).getTargetEntity().orElse(null);
                        return entity != null && entity.equals(FamiliesReferenceTreeTablePanel.this.mRoot);
                    }
                    return false;
                }
                return false;
            }
        };
        ColorHighlighter hl = new ColorHighlighter(MyHighlightPredicate, this.familiesTreeTable.getBackground(), Color.blue);
        this.familiesTreeTable.addHighlighter((Highlighter)hl);
        if (this.mFamilyEditingType == EDIT_FAMC) {
            this.addFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.addFamilyButton.familiesChildren.toolTipText"));
        } else {
            this.addFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.addFamilyButton.familiesSpouses.toolTipText"));
        }
    }

    private void initComponents() {
        this.familiesScrollPane = new JScrollPane();
        this.familiesTreeTable = new JXTreeTable((TreeTableModel)new FamilyReferencesTreeTableModel(this.mFamilyEditingType));
        this.familyNamesToolBar = new JToolBar();
        this.addFamilyButton = new JButton();
        this.linkToFamilyButton = new JButton();
        this.editButton = new JButton();
        this.deleteFamilyButton = new JButton();
        this.familiesTreeTable.setEditable(false);
        this.familiesTreeTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FamiliesReferenceTreeTablePanel.this.familiesTreeTableMouseClicked(evt);
            }
        });
        this.familiesScrollPane.setViewportView((Component)this.familiesTreeTable);
        this.familyNamesToolBar.setFloatable(false);
        this.familyNamesToolBar.setRollover(true);
        this.addFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_add.png")));
        this.addFamilyButton.setHorizontalTextPosition(0);
        this.addFamilyButton.setVerticalTextPosition(3);
        this.addFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesReferenceTreeTablePanel.this.addFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.addFamilyButton);
        this.linkToFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/link_add.png")));
        this.linkToFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.linkToFamilyButton.toolTipText"));
        this.linkToFamilyButton.setHorizontalTextPosition(4);
        this.linkToFamilyButton.setVerticalTextPosition(3);
        this.linkToFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesReferenceTreeTablePanel.this.linkToFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.linkToFamilyButton);
        this.editButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit.png")));
        this.editButton.setToolTipText(NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.editButton.toolTipText"));
        this.editButton.setHorizontalTextPosition(0);
        this.editButton.setVerticalTextPosition(3);
        this.editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesReferenceTreeTablePanel.this.editButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.editButton);
        this.deleteFamilyButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/aries/resources/edit_delete.png")));
        this.deleteFamilyButton.setToolTipText(NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteFamilyButton.toolTipText"));
        this.deleteFamilyButton.setHorizontalTextPosition(0);
        this.deleteFamilyButton.setVerticalTextPosition(3);
        this.deleteFamilyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FamiliesReferenceTreeTablePanel.this.deleteFamilyButtonActionPerformed(evt);
            }
        });
        this.familyNamesToolBar.add(this.deleteFamilyButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.familiesScrollPane, -1, 539, Short.MAX_VALUE).addComponent(this.familyNamesToolBar, -1, 539, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.familyNamesToolBar, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.familiesScrollPane, -1, 154, Short.MAX_VALUE)));
    }

    private void addFamilyButtonActionPerformed(ActionEvent evt) {
        Gedcom gedcom = this.mRoot.getGedcom();
        int undoNb = gedcom.getUndoNb();
        try {
            gedcom.doUnitOfWork(new UnitOfWork(){

                public void perform(Gedcom gedcom) throws GedcomException {
                    FamiliesReferenceTreeTablePanel.this.mCreateFamily = (Fam)gedcom.createEntity("FAM");
                    if (FamiliesReferenceTreeTablePanel.this.mFamilyEditingType == EDIT_FAMC) {
                        FamiliesReferenceTreeTablePanel.this.mAddChild = FamiliesReferenceTreeTablePanel.this.mCreateFamily.addChild((Indi)FamiliesReferenceTreeTablePanel.this.mRoot);
                    } else if (FamiliesReferenceTreeTablePanel.this.mFamilyEditingType == EDIT_FAMS) {
                        if (((Indi)FamiliesReferenceTreeTablePanel.this.mRoot).getSex() == 1) {
                            FamiliesReferenceTreeTablePanel.this.mCreateFamily.setHusband((Indi)FamiliesReferenceTreeTablePanel.this.mRoot);
                        } else {
                            FamiliesReferenceTreeTablePanel.this.mCreateFamily.setWife((Indi)FamiliesReferenceTreeTablePanel.this.mRoot);
                        }
                    }
                }
            });
            FamilyEditor familyEditor = new FamilyEditor(true);
            familyEditor.setContext(new Context((Entity)this.mCreateFamily));
            familyEditor.addChangeListener(this.changeListner);
            AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
            atc.getOpenEditors().add(familyEditor);
            if (familyEditor.showPanel()) {
                ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).clear();
                if (this.mFamilyEditingType == EDIT_FAMC) {
                    ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).addAll(this.mRoot.getProperties(PropertyFamilyChild.class));
                } else if (this.mFamilyEditingType == EDIT_FAMS) {
                    ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).addAll(this.mRoot.getProperties(PropertyFamilySpouse.class));
                }
                this.familiesTreeTable.expandAll();
            } else {
                while (gedcom.getUndoNb() > undoNb && gedcom.canUndo()) {
                    gedcom.undoUnitOfWork(false);
                }
            }
            familyEditor.removeChangeListener(this.changeListner);
            atc.getOpenEditors().remove((Object)familyEditor);
        }
        catch (GedcomException ex) {
            LOGGER.log(Level.INFO, "Unable to commit changes", ex);
        }
    }

    private void linkToFamilyButtonActionPerformed(ActionEvent evt) {
        Fam selectedFamily;
        FamiliesTablePanel familiesTablePanel = new FamiliesTablePanel(LIST_FAM);
        familiesTablePanel.set(this.mRoot, new ArrayList<Fam>(this.mRoot.getGedcom().getFamilies()));
        DialogManager.ADialog familiesTableDialog = new DialogManager.ADialog(NbBundle.getMessage(FamiliesTablePanel.class, (String)"familiesTableDialog.linkto.title"), (JComponent)familiesTablePanel);
        familiesTableDialog.setDialogId(FamiliesTablePanel.class.getName());
        if (familiesTableDialog.show() == DialogDescriptor.OK_OPTION && (selectedFamily = familiesTablePanel.getSelectedFamily()) != null) {
            try {
                this.mRoot.getGedcom().doUnitOfWork(new UnitOfWork(){

                    public void perform(Gedcom gedcom) throws GedcomException {
                        if (FamiliesReferenceTreeTablePanel.this.mFamilyEditingType == EDIT_FAMC) {
                            PropertyXRef addChild = selectedFamily.addChild((Indi)FamiliesReferenceTreeTablePanel.this.mRoot);
                            ((FamilyReferencesTreeTableModel)FamiliesReferenceTreeTablePanel.this.familiesTreeTable.getTreeTableModel()).add(addChild);
                        } else if (FamiliesReferenceTreeTablePanel.this.mFamilyEditingType == EDIT_FAMS) {
                            if (((Indi)FamiliesReferenceTreeTablePanel.this.mRoot).getSex() == 1) {
                                selectedFamily.setHusband((Indi)FamiliesReferenceTreeTablePanel.this.mRoot);
                            } else {
                                selectedFamily.setWife((Indi)FamiliesReferenceTreeTablePanel.this.mRoot);
                            }
                        }
                    }
                });
                ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).clear();
                if (this.mFamilyEditingType == EDIT_FAMC) {
                    ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).addAll(this.mRoot.getProperties(PropertyFamilyChild.class));
                } else if (this.mFamilyEditingType == EDIT_FAMS) {
                    ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).addAll(this.mRoot.getProperties(PropertyFamilySpouse.class));
                }
                this.familiesTreeTable.expandAll();
                this.changeSupport.fireChange();
            }
            catch (GedcomException ex) {
                LOGGER.log(Level.INFO, "Unable to commit changes", ex);
            }
        }
        familiesTablePanel.saveFilterSettings();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode dataNode;
        Property property;
        TreePath path;
        Object node;
        Gedcom gedcom = this.mRoot.getGedcom();
        int rowIndex = this.familiesTreeTable.convertRowIndexToModel(this.familiesTreeTable.getSelectedRow());
        if (rowIndex != -1 && (node = (path = this.familiesTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (property = (Property)(dataNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof PropertyXRef) {
            Indi child;
            Entity entity = ((PropertyXRef)property).getTargetEntity().orElse(null);
            if (entity instanceof Fam) {
                Fam family = (Fam)entity;
                FamilyEditor familyEditor = new FamilyEditor();
                familyEditor.setContext(new Context((Entity)family));
                familyEditor.addChangeListener(this.changeListner);
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(familyEditor);
                familyEditor.showPanel();
                familyEditor.removeChangeListener(this.changeListner);
                atc.getOpenEditors().remove((Object)familyEditor);
            } else if (entity instanceof Indi && !(child = (Indi)entity).equals(this.mRoot)) {
                IndividualEditor individualEditor = new IndividualEditor();
                individualEditor.setContext(new Context((Entity)child));
                individualEditor.addChangeListener(this.changeListner);
                AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                atc.getOpenEditors().add(individualEditor);
                individualEditor.showPanel();
                individualEditor.removeChangeListener(this.changeListner);
                atc.getOpenEditors().remove((Object)individualEditor);
            }
        }
    }

    private void deleteFamilyButtonActionPerformed(ActionEvent evt) {
        DefaultMutableTreeNode dataNode;
        Property property;
        TreePath path;
        Object node;
        int rowIndex = this.familiesTreeTable.convertRowIndexToModel(this.familiesTreeTable.getSelectedRow());
        Gedcom gedcom = this.mRoot.getGedcom();
        if (rowIndex != -1 && (node = (path = this.familiesTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (property = (Property)(dataNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof PropertyXRef) {
            Optional oEntity;
            Entity fEntity;
            Property parentProperty;
            TreeNode parent;
            Entity entity = ((PropertyXRef)property).getTargetEntity().orElse(null);
            if (entity instanceof Fam) {
                Fam family = (Fam)entity;
                DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteFamilyConfirmation.title", (Object)family), (String)NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteFamilyConfirmation.text", (Object)family, (Object)this.mRoot));
                if (createYesNo.show() == DialogManager.YES_OPTION) {
                    try {
                        gedcom.doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                FamiliesReferenceTreeTablePanel.this.mRoot.delProperty(property);
                            }
                        });
                        ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).remove(dataNode);
                        this.changeSupport.fireChange();
                    }
                    catch (GedcomException ex) {
                        LOGGER.log(Level.INFO, "Unable to commit changes", ex);
                    }
                }
            } else if (entity instanceof Indi && (parent = dataNode.getParent()) instanceof DefaultMutableTreeNode && (parentProperty = (Property)((DefaultMutableTreeNode)parent).getUserObject()) instanceof PropertyXRef && (fEntity = (Entity)(oEntity = ((PropertyXRef)parentProperty).getTargetEntity()).orElse(null)) instanceof Fam) {
                final Fam family = (Fam)fEntity;
                DialogManager createYesNo = DialogManager.createYesNo((String)NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteChildConfirmation.title", (Object)entity), (String)NbBundle.getMessage(FamiliesReferenceTreeTablePanel.class, (String)"FamiliesReferenceTreeTablePanel.deleteChildConfirmation.text", (Object)entity, (Object)family));
                if (createYesNo.show() == DialogManager.YES_OPTION) {
                    try {
                        gedcom.doUnitOfWork(new UnitOfWork(){

                            public void perform(Gedcom gedcom) throws GedcomException {
                                family.delProperty(property);
                            }
                        });
                        ((FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel()).remove(dataNode);
                        this.changeSupport.fireChange();
                    }
                    catch (GedcomException ex) {
                        LOGGER.log(Level.INFO, "Unable to commit changes", ex);
                    }
                }
            }
        }
    }

    private void familiesTreeTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() >= 2) {
            DefaultMutableTreeNode dataNode;
            Property property;
            TreePath path;
            Object node;
            int rowIndex = this.familiesTreeTable.convertRowIndexToModel(this.familiesTreeTable.getSelectedRow());
            Gedcom gedcom = this.mRoot.getGedcom();
            if (rowIndex != -1 && (node = (path = this.familiesTreeTable.getPathForRow(rowIndex)).getLastPathComponent()) instanceof DefaultMutableTreeNode && (property = (Property)(dataNode = (DefaultMutableTreeNode)node).getUserObject()) instanceof PropertyXRef) {
                Indi child;
                Entity entity = ((PropertyXRef)property).getTargetEntity().orElse(null);
                if (entity instanceof Fam) {
                    Fam family = (Fam)entity;
                    FamilyEditor familyEditor = new FamilyEditor();
                    familyEditor.setContext(new Context((Entity)family));
                    familyEditor.addChangeListener(this.changeListner);
                    AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                    atc.getOpenEditors().add(familyEditor);
                    familyEditor.showPanel();
                    familyEditor.removeChangeListener(this.changeListner);
                    atc.getOpenEditors().add(familyEditor);
                } else if (entity instanceof Indi && !(child = (Indi)entity).equals(this.mRoot)) {
                    IndividualEditor individualEditor = new IndividualEditor();
                    individualEditor.setContext(new Context((Entity)child));
                    individualEditor.addChangeListener(this.changeListner);
                    AriesTopComponent atc = AriesTopComponent.findEditorWindow(gedcom);
                    atc.getOpenEditors().add(individualEditor);
                    individualEditor.showPanel();
                    individualEditor.removeChangeListener(this.changeListner);
                    atc.getOpenEditors().remove((Object)individualEditor);
                }
            }
        }
    }

    public void setFamiliesList(Property root, List<? extends PropertyXRef> familiesList) {
        this.mRoot = root;
        FamilyReferencesTreeTableModel familyReferencesTreeTableModel = (FamilyReferencesTreeTableModel)this.familiesTreeTable.getTreeTableModel();
        familyReferencesTreeTableModel.setRoot(this.mRoot);
        familyReferencesTreeTableModel.clear();
        familyReferencesTreeTableModel.addAll(familiesList);
        this.familiesTreeTable.getColumnModel().addColumnModelListener(new FamiliesTreeTableTableColumnModelListener());
        this.familiesTreeTable.expandAll();
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    private class ChangeListner
    implements ChangeListener {
        private ChangeListner() {
        }

        @Override
        public void stateChanged(ChangeEvent ce) {
            FamiliesReferenceTreeTablePanel.this.changeSupport.fireChange();
        }
    }

    private class FamiliesTreeTableTableColumnModelListener
    implements TableColumnModelListener {
        private final Logger logger = Logger.getLogger(FamiliesTreeTableTableColumnModelListener.class.getName(), null);

        private FamiliesTreeTableTableColumnModelListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnAdded: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnRemoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMoved(TableColumnModelEvent tcme) {
            this.logger.log(Level.FINE, "columnMoved: {0}", tcme.getFromIndex());
        }

        @Override
        public void columnMarginChanged(ChangeEvent ce) {
            this.logger.log(Level.FINE, "columnMarginChanged: {0}", ce.toString());
            for (int index = 0; index < FamiliesReferenceTreeTablePanel.this.familiesTreeTable.getColumnCount(); ++index) {
                int preferredWidth = FamiliesReferenceTreeTablePanel.this.familiesTreeTable.getColumn(index).getPreferredWidth();
                this.logger.log(Level.FINE, "columnMarginChanged: table id {0} column index {1} size {2}", new Object[]{FamiliesReferenceTreeTablePanel.this.mTableId, index, preferredWidth});
                FamiliesReferenceTreeTablePanel.this.mRegistry.put(FamiliesReferenceTreeTablePanel.this.mTableId + ".column" + index + ".size", preferredWidth);
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent lse) {
        }
    }
}

