/*
 * Decompiled with CFR 0.152.
 */
package ancestris.gedcom;

import genj.util.Registry;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;

public abstract class RecentFiles {
    static final Logger LOG = Logger.getLogger("ancestris.app");
    static final Registry REGISTRY = Registry.get(RecentFiles.class);
    public static final String PROP_RECENT_FILE_INFO = "RecentFiletInformation";
    protected PropertyChangeSupport pch = new PropertyChangeSupport(this);
    private static RecentFiles defaultInstance;

    public abstract void add(FileObject var1);

    public abstract void remove(FileObject var1);

    public abstract List<FileObject> getAll();

    public abstract void clearList();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pch.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pch.removePropertyChangeListener(listener);
    }

    public static RecentFiles getDefault() {
        RecentFiles instance = (RecentFiles)Lookup.getDefault().lookup(RecentFiles.class);
        return instance != null ? instance : RecentFiles.getDefaultInstance();
    }

    private static synchronized RecentFiles getDefaultInstance() {
        if (defaultInstance == null) {
            defaultInstance = new DefaultHistoryImpl();
        }
        return defaultInstance;
    }

    private static class DefaultHistoryImpl
    extends RecentFiles {
        private DefaultHistoryImpl() {
        }

        @Override
        public void add(FileObject gedcomFile) {
            if (!gedcomFile.isValid()) {
                return;
            }
            String url = gedcomFile.toURL().toString();
            List<String> history = REGISTRY.get("history", (List<String>)new ArrayList<String>());
            history.remove(url);
            history.add(0, url);
            if (history.size() > 15) {
                history.remove(history.size() - 1);
            }
            REGISTRY.put("history", history);
            this.pch.firePropertyChange(new PropertyChangeEvent(RecentFiles.class, RecentFiles.PROP_RECENT_FILE_INFO, null, null));
        }

        @Override
        public void remove(FileObject gedcomFile) {
            String url;
            try {
                url = gedcomFile.toURL().toString();
            }
            catch (Throwable ex) {
                return;
            }
            List<String> history = REGISTRY.get("history", (List<String>)new ArrayList<String>());
            history.remove(url);
            REGISTRY.put("history", history);
            this.pch.firePropertyChange(new PropertyChangeEvent(RecentFiles.class, RecentFiles.PROP_RECENT_FILE_INFO, null, null));
        }

        @Override
        public List<FileObject> getAll() {
            List<String> list = REGISTRY.get("history", (List<String>)new ArrayList<String>());
            ArrayList<FileObject> result = new ArrayList<FileObject>(5);
            for (String file : list) {
                try {
                    FileObject fo = URLMapper.findFileObject((URL)new URL(file));
                    if (fo == null) continue;
                    result.add(URLMapper.findFileObject((URL)new URL(file)));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return result;
        }

        @Override
        public void clearList() {
            for (FileObject fo : this.getAll()) {
                this.remove(fo);
            }
        }
    }
}

