// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use glib::object::IsA;
use glib::translate::*;
use pango_sys;
use std::fmt;
use Color;
use Font;
use Glyph;
use GlyphItem;
use GlyphString;
use Layout;
use LayoutLine;
use Matrix;
use RenderPart;

glib_wrapper! {
    pub struct Renderer(Object<pango_sys::PangoRenderer, pango_sys::PangoRendererClass, RendererClass>);

    match fn {
        get_type => || pango_sys::pango_renderer_get_type(),
    }
}

pub const NONE_RENDERER: Option<&Renderer> = None;

pub trait RendererExt: 'static {
    fn activate(&self);

    fn deactivate(&self);

    fn draw_error_underline(&self, x: i32, y: i32, width: i32, height: i32);

    fn draw_glyph<P: IsA<Font>>(&self, font: &P, glyph: Glyph, x: f64, y: f64);

    fn draw_glyph_item(&self, text: Option<&str>, glyph_item: &mut GlyphItem, x: i32, y: i32);

    fn draw_glyphs<P: IsA<Font>>(&self, font: &P, glyphs: &mut GlyphString, x: i32, y: i32);

    fn draw_layout(&self, layout: &Layout, x: i32, y: i32);

    fn draw_layout_line(&self, line: &LayoutLine, x: i32, y: i32);

    fn draw_rectangle(&self, part: RenderPart, x: i32, y: i32, width: i32, height: i32);

    fn draw_trapezoid(
        &self,
        part: RenderPart,
        y1_: f64,
        x11: f64,
        x21: f64,
        y2: f64,
        x12: f64,
        x22: f64,
    );

    #[cfg(any(feature = "v1_38", feature = "dox"))]
    fn get_alpha(&self, part: RenderPart) -> u16;

    fn get_color(&self, part: RenderPart) -> Option<Color>;

    fn get_layout(&self) -> Option<Layout>;

    fn get_layout_line(&self) -> Option<LayoutLine>;

    fn get_matrix(&self) -> Option<Matrix>;

    fn part_changed(&self, part: RenderPart);

    #[cfg(any(feature = "v1_38", feature = "dox"))]
    fn set_alpha(&self, part: RenderPart, alpha: u16);

    fn set_color(&self, part: RenderPart, color: Option<&Color>);

    fn set_matrix(&self, matrix: Option<&Matrix>);
}

impl<O: IsA<Renderer>> RendererExt for O {
    fn activate(&self) {
        unsafe {
            pango_sys::pango_renderer_activate(self.as_ref().to_glib_none().0);
        }
    }

    fn deactivate(&self) {
        unsafe {
            pango_sys::pango_renderer_deactivate(self.as_ref().to_glib_none().0);
        }
    }

    fn draw_error_underline(&self, x: i32, y: i32, width: i32, height: i32) {
        unsafe {
            pango_sys::pango_renderer_draw_error_underline(
                self.as_ref().to_glib_none().0,
                x,
                y,
                width,
                height,
            );
        }
    }

    fn draw_glyph<P: IsA<Font>>(&self, font: &P, glyph: Glyph, x: f64, y: f64) {
        unsafe {
            pango_sys::pango_renderer_draw_glyph(
                self.as_ref().to_glib_none().0,
                font.as_ref().to_glib_none().0,
                glyph,
                x,
                y,
            );
        }
    }

    fn draw_glyph_item(&self, text: Option<&str>, glyph_item: &mut GlyphItem, x: i32, y: i32) {
        unsafe {
            pango_sys::pango_renderer_draw_glyph_item(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                glyph_item.to_glib_none_mut().0,
                x,
                y,
            );
        }
    }

    fn draw_glyphs<P: IsA<Font>>(&self, font: &P, glyphs: &mut GlyphString, x: i32, y: i32) {
        unsafe {
            pango_sys::pango_renderer_draw_glyphs(
                self.as_ref().to_glib_none().0,
                font.as_ref().to_glib_none().0,
                glyphs.to_glib_none_mut().0,
                x,
                y,
            );
        }
    }

    fn draw_layout(&self, layout: &Layout, x: i32, y: i32) {
        unsafe {
            pango_sys::pango_renderer_draw_layout(
                self.as_ref().to_glib_none().0,
                layout.to_glib_none().0,
                x,
                y,
            );
        }
    }

    fn draw_layout_line(&self, line: &LayoutLine, x: i32, y: i32) {
        unsafe {
            pango_sys::pango_renderer_draw_layout_line(
                self.as_ref().to_glib_none().0,
                line.to_glib_none().0,
                x,
                y,
            );
        }
    }

    fn draw_rectangle(&self, part: RenderPart, x: i32, y: i32, width: i32, height: i32) {
        unsafe {
            pango_sys::pango_renderer_draw_rectangle(
                self.as_ref().to_glib_none().0,
                part.to_glib(),
                x,
                y,
                width,
                height,
            );
        }
    }

    fn draw_trapezoid(
        &self,
        part: RenderPart,
        y1_: f64,
        x11: f64,
        x21: f64,
        y2: f64,
        x12: f64,
        x22: f64,
    ) {
        unsafe {
            pango_sys::pango_renderer_draw_trapezoid(
                self.as_ref().to_glib_none().0,
                part.to_glib(),
                y1_,
                x11,
                x21,
                y2,
                x12,
                x22,
            );
        }
    }

    #[cfg(any(feature = "v1_38", feature = "dox"))]
    fn get_alpha(&self, part: RenderPart) -> u16 {
        unsafe {
            pango_sys::pango_renderer_get_alpha(self.as_ref().to_glib_none().0, part.to_glib())
        }
    }

    fn get_color(&self, part: RenderPart) -> Option<Color> {
        unsafe {
            from_glib_none(pango_sys::pango_renderer_get_color(
                self.as_ref().to_glib_none().0,
                part.to_glib(),
            ))
        }
    }

    fn get_layout(&self) -> Option<Layout> {
        unsafe {
            from_glib_none(pango_sys::pango_renderer_get_layout(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_layout_line(&self) -> Option<LayoutLine> {
        unsafe {
            from_glib_none(pango_sys::pango_renderer_get_layout_line(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_matrix(&self) -> Option<Matrix> {
        unsafe {
            from_glib_none(pango_sys::pango_renderer_get_matrix(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn part_changed(&self, part: RenderPart) {
        unsafe {
            pango_sys::pango_renderer_part_changed(self.as_ref().to_glib_none().0, part.to_glib());
        }
    }

    #[cfg(any(feature = "v1_38", feature = "dox"))]
    fn set_alpha(&self, part: RenderPart, alpha: u16) {
        unsafe {
            pango_sys::pango_renderer_set_alpha(
                self.as_ref().to_glib_none().0,
                part.to_glib(),
                alpha,
            );
        }
    }

    fn set_color(&self, part: RenderPart, color: Option<&Color>) {
        unsafe {
            pango_sys::pango_renderer_set_color(
                self.as_ref().to_glib_none().0,
                part.to_glib(),
                color.to_glib_none().0,
            );
        }
    }

    fn set_matrix(&self, matrix: Option<&Matrix>) {
        unsafe {
            pango_sys::pango_renderer_set_matrix(
                self.as_ref().to_glib_none().0,
                matrix.to_glib_none().0,
            );
        }
    }
}

impl fmt::Display for Renderer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "Renderer")
    }
}
